local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end
function RandBetween(a, b)
	local r = rand()
	local d = b-a
	local e = d*r
	return a + e
end

function GetAngleFacingClaw(self)
	local claw = GetClaw()
	return math.deg(math.atan2(claw.Y-self.Y,claw.X-self.X))
end

function GetDistanceTo(self, x, y)
	return math.sqrt((y-self.Y)^2+(x-self.X)^2)
end

function main(self)
	local claw = GetClaw()
	if self.State == 0 then
		self.startX = self.X
		self.startY = self.Y
		self.startTime = GetTime()
		self.startTime1 = GetTime()
		self.BoundaryLeft = 11392
		self.BoundaryRight = 12362
		self.BoundaryBottom = 2374
		self.BoundaryTop = 1094
		if self.Damage == 0 then
			self.Damage = 5
		end
		if self.Speed ~= 1000 then
			self.Speed = 1000
		end
		if self.Health == 0 then
			self.Health = 5000
		end
		self.Angle = math.rad(self.Counter)
		self.BulletType = self.Smarts
		if self.BulletType == 2 or self.BulletType == 3 or self.BulletType == 6 or self.BulletType == 16 or self.BulletType == 17 then -- slash bullet
			self:SetImage("CUSTOM_DANMAKU_SLASH")
			self.I = (self.Counter/3)%120+1
			--TextOut(self.I)
		end
		if self.BulletType == 9 or self.BulletType == 11 or self.BulletType == 14 then -- fish bullet
			self:SetImage("CUSTOM_DANMAKU_FISH")
			self.I = (self.Counter/3)%120+1
			--TextOut(self.I)
		end
		if self.BulletType == 5 or self.BulletType == 10 then
			self.DrawFlags.NoDraw = true
		end
		if self.BulletType == 7 then
			distance = 0
		end
		self.distance = 0
		self.TimeStopFlag = 0
		if self.BulletType == 6 then
			local claw = GetClaw()
			self.distance = math.sqrt(math.pow(claw.Y - self.Y,2) + math.pow(claw.X - self.X,2))
			local d1 = self.distance / 5
			local d2 = self.distance - self.Points
			if d1 > d2 then
				self.distance = d1
			else
				self.distance = d2
			end
			self.TimeStopFlag = 1
		end
		self.Timer = GetTime()
		self:SetFrame(self.I)
		self.Attempt = Attempt()
		self.BossStager = GetObject(4098)
		self.Achievements = GetObject(4088)
		self.GrazedFlag = 0
		self.State = 1
		
		self.lastDistance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y)
		self.Token = 0
	elseif self.State == 1 then
		if self.TimeStopFlag == 0 and self.BulletType ~= 6 then
			if self.BossStager.TimeStoppedTill >= GetTime() then
				self.TimeStopFlag = 1
				self.startTime = self.startTime + self.BossStager.TimeStoppedDuration
			end
		elseif self.TimeStopFlag == 1 and self.BulletType ~= 6 then
			if self.BossStager.TimeStoppedTill < GetTime() then
				self.TimeStopFlag = 0
			end
		end
		if self.TimeStopFlag == 0 then
			if self.BulletType == 1 then -- straight bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
			elseif self.BulletType == 2 then -- slash bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
			elseif self.BulletType == 3 then -- homing bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if self.Token == 0 and GetTime()-self.startTime >= 750 then
					self.startX = self.X
					self.startY = self.Y
					self.Angle = math.rad(GetAngleFacingClaw(self))
					self.startTime = GetTime()
					self.Token = 1
				end
			elseif self.BulletType == 4 then -- exploding bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
			elseif self.BulletType == 5 then -- delayed slash
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if GetTime() >= self.Timer + 50 then
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="DelayedSlash", logic="CustomLogic", image="CUSTOM_SPARKLEREDBIG", Damage = 0, Counter = self.Counter, Smarts = 2, Health = 2000}
					b.Flags.AlwaysActive = true
					--b = CreateObject {x=self.X + RandBetween(-5,5), y=self.Y + RandBetween(-5,5), z=4050, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
					--b.Flags.AlwaysActive = true
					--b = CreateObject {x=self.X + RandBetween(-10,10), y=self.Y + RandBetween(-15,15), z=4050, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
					--b.Flags.AlwaysActive = true
					self.Timer = GetTime()
				end
			-- 6 - time stop bullet
			elseif self.BulletType == 7 then -- orbiting bullet
				if self.distance < 128 then
					self.distance = self.distance + 1
				end
				currentAngle = self.Angle + (GetTime()-self.startTime)/1000
				self.X = self.startX + math.cos(currentAngle)*self.distance
				self.Y = self.startY + math.sin(currentAngle)*self.distance
				if GetTime()-self.startTime >= 48000 then
					self:Destroy()
				end
			elseif self.BulletType == 8 then -- falling bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				local bossdistance = math.abs(self.X - self.SpeedX) + math.abs(self.Y - self.SpeedY)
				if bossdistance <= 36 then
					self:Destroy()
				end
			elseif self.BulletType == 9 then -- proximity bullet (ascending fish)
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if self.Token == 0 and self.Y > claw.Y then
					if (self.X - claw.X)^2 + (self.Y - claw.Y)^2 < 250^2 then
						self.startX = self.X
						self.startY = self.Y
						self.Angle = math.rad(GetAngleFacingClaw(self))
						self.Counter = GetAngleFacingClaw(self)
						self.I = (self.Counter/3)%120+1
						self:SetFrame(self.I)
						self.startTime = GetTime()
						self.Token = 1
					end
				end
				--self.lastDistance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y)
			elseif self.BulletType == 11 then -- proximity bullet 2 (machine gun fish)
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if self.Token == 0 then
					if (self.X - claw.X)^2 + (self.Y - claw.Y)^2 < 250^2 then
						self.startX = self.X
						self.startY = self.Y
						self.Angle = math.rad(GetAngleFacingClaw(self))
						self.Counter = GetAngleFacingClaw(self)
						self.I = (self.Counter/3)%120+1
						self:SetFrame(self.I)
						self.startTime = GetTime()
						self.Token = 1
					end
				end
				--self.lastDistance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y)
			elseif self.BulletType == 14 then -- proximity bullet 3 (fish rain)
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if self.Token == 0 and self.Y < claw.Y then
					if self.BossStager ~= nil then
						if self.BossStager.Areti ~= nil then
							if self.BossStager.Areti.phantomAreti ~= nil then
								if self.BossStager.Areti.phantomAreti.hotY ~= nil then
									if self.BossStager.Areti.phantomAreti.hotY < self.Y then
										self.startX = self.X
										self.startY = self.Y
										self.startTime = GetTime()
										self.Health = self.Health + 1000
										self.Token = 1
										--TextOut(self.Token)
									end
								end
							end
						end
					end
				end
				if self.Token == 1 and self.Y < claw.Y then
					if self.BossStager ~= nil then
						if self.BossStager.Areti ~= nil then
							if self.BossStager.Areti.phantomAreti ~= nil then
								if self.BossStager.Areti.phantomAreti.hotY ~= nil then
									if self.BossStager.Areti.phantomAreti.hotY < self.Y then
										
										local a = self.Counter
										local b = GetAngleFacingClaw(self)
										local d = (a%360)-(b%360)
										if d <= 30 and d >= -30 then
											self.startX = self.X
											self.startY = self.Y
											self.Angle = math.rad(GetAngleFacingClaw(self))
											self.Counter = GetAngleFacingClaw(self)
											self.I = (self.Counter/3)%120+1
											self:SetFrame(self.I)
											self.startTime = GetTime()
											self.Health = self.Health - 1500
											self.Token = 2
										end
									end
								end
							end
						end
					end
					
				end
				--self.lastDistance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y)
			elseif self.BulletType == 10 then -- delayed slash
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if GetTime() >= self.Timer + 50 then
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="DelayedAimedSlash", logic="CustomLogic", image="CUSTOM_SPARKLEREDBIG", Damage = 0, Counter = self.Counter, Smarts = 2, Health = 6000}
					b.Flags.AlwaysActive = true
					--b = CreateObject {x=self.X + RandBetween(-5,5), y=self.Y + RandBetween(-5,5), z=4050, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
					--b.Flags.AlwaysActive = true
					--b = CreateObject {x=self.X + RandBetween(-10,10), y=self.Y + RandBetween(-15,15), z=4050, name="Spark", logic="CustomLogic", image="CUSTOM_SPARKLERED"}
					--b.Flags.AlwaysActive = true
					self.Timer = GetTime()
				end
			elseif self.BulletType == 12 then -- splitting bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if GetTime() > self.startTime1 + 220 then
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = self.Counter + 90, Smarts = 1, Health = self.Health}
					b.Flags.AlwaysActive = true
					b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = self.Counter - 90, Smarts = 1, Health = self.Health}
					b.Flags.AlwaysActive = true
					self.startTime1 = GetTime()
				end
			elseif self.BulletType == 16 then -- splitting bullet (slash)
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if GetTime() > self.startTime1 + 300 then
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = self.Counter + 90, Smarts = 17, Health = self.Health}
					b.Flags.AlwaysActive = true
					b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = self.Counter - 90, Smarts = 17, Health = self.Health}
					b.Flags.AlwaysActive = true
					self.startTime1 = GetTime()
				end
			elseif self.BulletType == 17 then -- slash bullet without spawnkilling
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
			elseif self.BulletType == 15 then -- splitting bullet - unused
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if GetTime() > self.startTime1 + 660 then
					local b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = 45, Smarts = 1, Health = 2500}
					b.Flags.AlwaysActive = true
					b = CreateObject {x=self.X, y=self.Y, z=4100, I=1, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = 135, Smarts = 1, Health = 2500}
					b.Flags.AlwaysActive = true
					self.startTime1 = GetTime()
				end
			elseif self.BulletType == 13 then -- 10th spell bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				if GetDistanceTo(self, 11872, 1984) <= 264 then
					self:Destroy()
				end
			elseif self.BulletType == 99 then -- Triple Blade SC bullet
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed
				if self.Token == 0 and GetTime()-self.startTime >= 1000 and math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y) > self.lastDistance then
					self.startX = self.X
					self.startY = self.Y
					self.Angle = math.rad(GetAngleFacingClaw(self))
					self.Counter = GetAngleFacingClaw(self)
					self.startTime = GetTime()
					self.Token = 1
				end
				self.lastDistance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y)
			end
			
			local distance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y)
			if claw.State == 26 then
				distance = math.abs(self.X - claw.X) + math.abs(self.Y - claw.Y - 32)
			end
			if distance <= 16 and _CurrentPowerup[0] ~= 9917 and claw.Health > 0 and self.BulletType ~= 5 and self.BulletType ~= 10 then
				if self.BulletType ~= 17 then
					if claw.Height == 0 then
						ClawTakeDamage(self.Damage)
						self.Achievements.DamageTaken = self.Achievements.DamageTaken + 5
						if claw.Health > 0 then
							GetClaw().Height = 23
						end
					end
					if self.BulletType ~= 7 then
						self:Destroy()
					end
				elseif GetTime() > self.startTime + 500 then
					if claw.Height == 0 then
						ClawTakeDamage(self.Damage)
						self.Achievements.DamageTaken = self.Achievements.DamageTaken + 5
						if claw.Health > 0 then
							GetClaw().Height = 23
						end
					end
					self:Destroy()
				end
			end
			-- grazing
			if distance <= 35 and _CurrentPowerup[0] ~= 9917 and claw.Health > 0 and self.BulletType ~= 5 and self.BulletType ~= 10 and self.GrazedFlag == 0 and claw.Height == 0 then
				self.BossStager.GrazeCounter = self.BossStager.GrazeCounter + 1
				self.GrazedFlag = 1
				PlaySound("GAME_PUBOUNCE1")
			end
			--TextOut(distance)
			if self.X >= self.BoundaryRight or self.X <= self.BoundaryLeft or self.Y >= self.BoundaryBottom or self.Y <= self.BoundaryTop then
				if self.BulletType == 4 then
					local baseangle = 0
					local offsetx = 0
					local offsety = 0
					if self.X >= self.BoundaryRight then
						offsetx = -10
					elseif self.X <= self.BoundaryLeft then
						offsetx = 10
					end
					if self.Y >= self.BoundaryBottom then
						offsety = -10
					end
					
					for j=15,375,30 do
						local b = CreateObject {x=self.X+offsetx, y=self.Y+offsety, z=4100, I=3, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = j, Smarts = 1, Health = 0}
						b.Flags.AlwaysActive = true
					end
				end
				self:Destroy()
			end
		end
		if self.BulletType == 6 then -- time stop bullet
			if self.TimeStopFlag == 1 and self.BossStager.TimeStoppedTill < GetTime() then
				self.startX = self.X
				self.startY = self.Y
				self.startTime = GetTime()
				self.Health = 5000
				self.TimeStopFlag = 0
			end
			if self.TimeStopFlag == 0 then
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
			elseif self.TimeStopFlag == 1 and math.sqrt(math.pow(self.Y - self.startY,2) + math.pow(self.X - self.startX,2)) < self.distance then
				self.X = self.startX + math.cos(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
				self.Y = self.startY + math.sin(self.Angle)*(GetTime()-self.startTime)*self.Speed/self.Health
			end
			
		end
		if self.Attempt < Attempt() then 
			self:Destroy()
		end
	end
end

function attack(self)
	
end